/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.TorchBottomComponent;
import com.technicalitiesmc.scm.init.SCMComponents;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;

public class TorchTopComponent
extends CircuitComponentBase<TorchTopComponent> {
    private static final AABB BOUNDS = new AABB(0.1875, 0.0, 0.1875, 0.8125, 0.5625, 0.8125);
    static final VecDirectionFlags OUTPUT_SIDES = (VecDirectionFlags)VecDirectionFlags.horizontals().and((Enum)VecDirection.POS_Y);
    private static final InterfaceLookup<TorchTopComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, TorchTopComponent::getRedstoneSource).build();

    public TorchTopComponent(ComponentContext context) {
        super(SCMComponents.TORCH_TOP, context, INTERFACES);
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new TorchTopComponent(context);
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)Items.f_41978_);
    }

    private RedstoneSource getRedstoneSource(VecDirection direction) {
        CircuitComponent below = this.getNeighbor(VecDirection.NEG_Y, ComponentSlot.DEFAULT);
        if (below instanceof TorchBottomComponent) {
            TorchBottomComponent bottom = (TorchBottomComponent)below;
            return bottom.state ? RedstoneSource.full((direction == VecDirection.POS_Y ? 1 : 0) != 0) : RedstoneSource.off();
        }
        return null;
    }

    public void harvest(ComponentHarvestContext context) {
        CircuitComponent below = this.getNeighbor(VecDirection.NEG_Y, ComponentSlot.DEFAULT);
        if (below instanceof TorchBottomComponent) {
            below.spawnDrops(context);
        }
        this.removeComponentAt(Vec3i.f_123288_, ComponentSlot.DEFAULT, true);
        this.removeComponentAt(VecDirection.NEG_Y.getOffset(), ComponentSlot.DEFAULT, true);
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)Items.f_41978_);
        }
    }
}

